<?php

use handler\product_Query;
use handler\Post_skin_base;
use handler\swiper;
use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_shop_special extends \Elementor\Widget_Base {

    use product_Query;
    use Post_skin_base;
    use swiper;
    use basic_element;

    public function get_name() {
        return 'ar_woo_shop_special';
    }

    public function get_title() {
        return esc_html__('shop archive special', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_shop_special';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function get_layout_source() {
        global $post;

        $current_page_id = $post->ID;

        $posts = get_posts(array(
            'post_type'      => 'theme-blog',
            'posts_per_page' => -1, 
            'exclude'        => $current_page_id,
        ));

        $options = array();
        foreach ($posts as $post) {
            $options[$post->ID] = $post->post_title;
        }

        return $options;
    }

    protected function register_content_section_1() {

        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label'     => esc_html__( 'default Layout', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'options'   => [
                    'grid'     => esc_html__( 'Grid', THEME_NAME ),
                    'carousel' => esc_html__( 'Carousel', THEME_NAME ),
                ],
                'default'   => 'grid',
            ]
        );

        $this->add_control(
			'posts_layout',
			[
				'label'   => esc_html__( 'Posts layout', THEME_NAME ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => $this->get_layout_source(),
				'default' => 'post',
			]
		);

		$this->add_responsive_control(
			'columns',
			[ 
				'label' => esc_html__( 'Columns', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options' => [ 
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid.view-grid' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'width: calc(100% / {{SIZE}});',
					'{{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'width: calc(100% / {{SIZE}});',
				],
				'condition' => [ 
					'layout!' => 'carousel',
				],
			]
		);

		$this->add_responsive_control(
			'column_gap',
			[ 
				'label' => esc_html__( 'Column Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid.view-grid' => 'column-gap: {{SIZE}}{{UNIT}};',
					'body:not(.rtl) {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-right: {{SIZE}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .theme-posts-wrapper.layout-carousel .post-item' => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry' => 'margin-left: calc({{SIZE}}{{UNIT}} * -.5); margin-right: calc({{SIZE}}{{UNIT}} * -.5);',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'padding-left: calc({{SIZE}}{{UNIT}} * .5); padding-right: calc({{SIZE}}{{UNIT}} * .5);',
				],
				'condition' => [ 
					'layout!' => 'carousel',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[ 
				'label' => esc_html__( 'Row Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid.view-grid' => 'row-gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .theme-posts-wrapper.layout-masonry .post-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 
					'layout!' => 'carousel',
				],
			]
		);

		$this->add_control(
			'hover',
			[ 
				'label' => esc_html__( 'hover', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0',
				'options' => [ 
					'0' => esc_html__( '', THEME_NAME ),
					'1' => esc_html__( 'style 1', THEME_NAME ),
					'2' => esc_html__( 'style 2', THEME_NAME ),
					'3' => esc_html__( 'style 3', THEME_NAME ),
					'4' => esc_html__( 'style 4', THEME_NAME ),
					'5' => esc_html__( 'style 5', THEME_NAME ),
					'6' => esc_html__( 'style 6', THEME_NAME ),
					'7' => esc_html__( 'style 7', THEME_NAME ),
					'8' => esc_html__( 'style 8', THEME_NAME ),
					'9' => esc_html__( 'style 9', THEME_NAME ),
					'10' => esc_html__( 'style 10', THEME_NAME ),
					'11' => esc_html__( 'style 11', THEME_NAME ),
					'12' => esc_html__( 'style 12', THEME_NAME ),
					'13' => esc_html__( 'style 13', THEME_NAME ),
					'14' => esc_html__( 'style 14', THEME_NAME ),
					'15' => esc_html__( 'style 15', THEME_NAME ),
					'16' => esc_html__( 'style 16', THEME_NAME ),
					'17' => esc_html__( 'style 17', THEME_NAME ),
					'18' => esc_html__( 'style 18', THEME_NAME ),
					'19' => esc_html__( 'style 19', THEME_NAME ),
					'20' => esc_html__( 'style 20', THEME_NAME ),
					'21' => esc_html__( 'style 21', THEME_NAME ),
					'22' => esc_html__( 'style 22', THEME_NAME ),
					'23' => esc_html__( 'style 23', THEME_NAME ),
					'24' => esc_html__( 'style 24', THEME_NAME ),
					'25' => esc_html__( 'style 25', THEME_NAME ),
					'26' => esc_html__( 'style 26', THEME_NAME ),
					'27' => esc_html__( 'style 27', THEME_NAME ),
					'28' => esc_html__( 'style 28', THEME_NAME ),
					'29' => esc_html__( 'style 29', THEME_NAME ),
					'30' => esc_html__( 'style 30', THEME_NAME ),
				],
			]
		);

        $this->end_controls_section();
    }

	protected function register_content_section_2() {

		$this->start_controls_section(
			'section_layout_switch',
			[ 
				'label' => esc_html__( 'Switcher Layout', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [ 
					'layout' => 'grid',
				],
			]
		);

		$this->add_control(
			'show_grid_list_toggle',
			[ 
				'label' => esc_html__( 'Show View Switcher', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', THEME_NAME ),
				'label_off' => esc_html__( 'No', THEME_NAME ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [ 
					'layout' => 'grid',
				],
			]
		);

        $this->add_control(
			'grid-icon',
			[ 
				'label' => __( 'Grid icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'condition' => [ 
					'show_grid_list_toggle' => 'yes',
					'layout' => 'grid',
				],
			]
		);

		$this->add_control(
			'grid_view_layout',
			[ 
				'label' => esc_html__( 'Grid View Layout', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => $this->get_layout_source(),
				'default' => 'post',
				'condition' => [ 
					'show_grid_list_toggle' => 'yes',
					'layout' => 'grid',
				],
			]
		);

		$this->add_responsive_control(
			'grid_view_columns',
			[ 
				'label' => esc_html__( 'Grid View Columns', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options' => [ 
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid.view-grids' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
				],
				'condition' => [ 
					'layout' => 'grid',
					'show_grid_list_toggle' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'grid_view_column_gap',
			[ 
				'label' => esc_html__( 'Grid View Column Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid.view-grids' => 'column-gap: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 
					'layout' => 'grid',
					'show_grid_list_toggle' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'grid_view_row_gap',
			[ 
				'label' => esc_html__( 'Grid View Row Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid.view-grids' => 'row-gap: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 
					'layout' => 'grid',
					'show_grid_list_toggle' => 'yes',
				],
			]
		);

		$this->add_control(
			'grid_view_hover',
			[ 
				'label' => esc_html__( 'Grid View hover', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0',
				'options' => [ 
					'0' => esc_html__( '', THEME_NAME ),
					'1' => esc_html__( 'style 1', THEME_NAME ),
					'2' => esc_html__( 'style 2', THEME_NAME ),
					'3' => esc_html__( 'style 3', THEME_NAME ),
					'4' => esc_html__( 'style 4', THEME_NAME ),
					'5' => esc_html__( 'style 5', THEME_NAME ),
					'6' => esc_html__( 'style 6', THEME_NAME ),
					'7' => esc_html__( 'style 7', THEME_NAME ),
					'8' => esc_html__( 'style 8', THEME_NAME ),
					'9' => esc_html__( 'style 9', THEME_NAME ),
					'10' => esc_html__( 'style 10', THEME_NAME ),
					'11' => esc_html__( 'style 11', THEME_NAME ),
					'12' => esc_html__( 'style 12', THEME_NAME ),
					'13' => esc_html__( 'style 13', THEME_NAME ),
					'14' => esc_html__( 'style 14', THEME_NAME ),
					'15' => esc_html__( 'style 15', THEME_NAME ),
					'16' => esc_html__( 'style 16', THEME_NAME ),
					'17' => esc_html__( 'style 17', THEME_NAME ),
					'18' => esc_html__( 'style 18', THEME_NAME ),
					'19' => esc_html__( 'style 19', THEME_NAME ),
					'20' => esc_html__( 'style 20', THEME_NAME ),
					'21' => esc_html__( 'style 21', THEME_NAME ),
					'22' => esc_html__( 'style 22', THEME_NAME ),
					'23' => esc_html__( 'style 23', THEME_NAME ),
					'24' => esc_html__( 'style 24', THEME_NAME ),
					'25' => esc_html__( 'style 25', THEME_NAME ),
					'26' => esc_html__( 'style 26', THEME_NAME ),
					'27' => esc_html__( 'style 27', THEME_NAME ),
					'28' => esc_html__( 'style 28', THEME_NAME ),
					'29' => esc_html__( 'style 29', THEME_NAME ),
					'30' => esc_html__( 'style 30', THEME_NAME ),
				],
				'condition' => [ 
					'layout' => 'grid',
					'show_grid_list_toggle' => 'yes',
				],
			]
		);

        $this->add_control(
			'show_grid_list_editor',
			[ 
				'label' => esc_html__( 'Show grid View on editor', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', THEME_NAME ),
				'label_off' => esc_html__( 'No', THEME_NAME ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [ 
					'layout' => 'grid',
					'show_grid_list_toggle' => 'yes',
				],
			]
		);

		$this->add_control(
			'grid_list_view-sep',
			[ 
				'label' => esc_html__( 'List View', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [ 
					'layout' => 'grid',
					'show_grid_list_toggle' => 'yes',
				],
			]
		);

		$this->add_control(
			'list-icon',
			[ 
				'label' => __( 'list icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'condition' => [ 
					'show_grid_list_toggle' => 'yes',
					'layout' => 'grid',
				],
			]
		);

		$this->add_control(
			'list_view_layout',
			[ 
				'label' => esc_html__( 'List View Layout', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => $this->get_layout_source(),
				'default' => 'post',
				'condition' => [ 
					'show_grid_list_toggle' => 'yes',
					'layout' => 'grid',
				],
			]
		);

		$this->add_responsive_control(
			'list_view_columns',
			[ 
				'label' => esc_html__( 'list View Columns', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options' => [ 
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid.view-list' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
				],
				'condition' => [ 
					'layout' => 'grid',
					'show_grid_list_toggle' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'list_view_column_gap',
			[ 
				'label' => esc_html__( 'list View Column Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'render_type' => 'template',
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid.view-list' => 'column-gap: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 
					'layout' => 'grid',
					'show_grid_list_toggle' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'list_view_row_gap',
			[ 
				'label' => esc_html__( 'list View Row Gap', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'default' => [ 
					'size' => '20',
				],
				'range' => [ 
					'px' => [ 
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [ 
					'{{WRAPPER}} .theme-posts-wrapper.layout-grid.view-list' => 'row-gap: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 
					'layout' => 'grid',
					'show_grid_list_toggle' => 'yes',
				],
			]
		);

		$this->add_control(
			'list_view_hover',
			[ 
				'label' => esc_html__( 'list View hover', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0',
				'options' => [ 
					'0' => esc_html__( '', THEME_NAME ),
					'1' => esc_html__( 'style 1', THEME_NAME ),
					'2' => esc_html__( 'style 2', THEME_NAME ),
					'3' => esc_html__( 'style 3', THEME_NAME ),
					'4' => esc_html__( 'style 4', THEME_NAME ),
					'5' => esc_html__( 'style 5', THEME_NAME ),
					'6' => esc_html__( 'style 6', THEME_NAME ),
					'7' => esc_html__( 'style 7', THEME_NAME ),
					'8' => esc_html__( 'style 8', THEME_NAME ),
					'9' => esc_html__( 'style 9', THEME_NAME ),
					'10' => esc_html__( 'style 10', THEME_NAME ),
					'11' => esc_html__( 'style 11', THEME_NAME ),
					'12' => esc_html__( 'style 12', THEME_NAME ),
					'13' => esc_html__( 'style 13', THEME_NAME ),
					'14' => esc_html__( 'style 14', THEME_NAME ),
					'15' => esc_html__( 'style 15', THEME_NAME ),
					'16' => esc_html__( 'style 16', THEME_NAME ),
					'17' => esc_html__( 'style 17', THEME_NAME ),
					'18' => esc_html__( 'style 18', THEME_NAME ),
					'19' => esc_html__( 'style 19', THEME_NAME ),
					'20' => esc_html__( 'style 20', THEME_NAME ),
					'21' => esc_html__( 'style 21', THEME_NAME ),
					'22' => esc_html__( 'style 22', THEME_NAME ),
					'23' => esc_html__( 'style 23', THEME_NAME ),
					'24' => esc_html__( 'style 24', THEME_NAME ),
					'25' => esc_html__( 'style 25', THEME_NAME ),
					'26' => esc_html__( 'style 26', THEME_NAME ),
					'27' => esc_html__( 'style 27', THEME_NAME ),
					'28' => esc_html__( 'style 28', THEME_NAME ),
					'29' => esc_html__( 'style 29', THEME_NAME ),
					'30' => esc_html__( 'style 30', THEME_NAME ),
				],
				'condition' => [ 
					'layout' => 'grid',
					'show_grid_list_toggle' => 'yes',
				],
			]
		);

		$this->add_control(
			'show_list_list_editor',
			[ 
				'label' => esc_html__( 'Show list View on editor', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', THEME_NAME ),
				'label_off' => esc_html__( 'No', THEME_NAME ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [ 
					'layout' => 'grid',
					'show_grid_list_toggle' => 'yes',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_style_section_1() {
		$this->start_controls_section( 'section_style_icons',
			[ 
				'label' => esc_html__( 'icons', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

        $this->register_container_style( 'switcher-container', '.switcher-container' );

		$this->start_controls_tabs( 'tabs_icons_style' );

		$this->start_controls_tab( 'tab_icon_normal',
			[ 
				'label' => esc_html__( 'Normal', THEME_NAME ),
			] );

		$this->add_control(
			'grid_icon_heading',
			[ 
				'label' => esc_html__( 'grid icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'normal_grid_icon', '.grid-icon', $align = false );

		$this->add_control(
			'list_icon_heading',
			[ 
				'label' => esc_html__( 'list icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'normal_list_icon', '.list-icon', $align = false);


		$this->end_controls_tab();

		$this->start_controls_tab( 'tab_icon_hover',
			[ 
				'label' => esc_html__( 'active', THEME_NAME ),
			] );

		$this->add_control(
			'grid_icon_hover_heading',
			[ 
				'label' => esc_html__( 'grid icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'normal_grid_icon_hover', '.grid-icon.active', $align = false );

		$this->add_control(
			'list_icon_hover_heading',
			[ 
				'label' => esc_html__( 'list icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'normal_list_icon_hover', '.list-icon.active', $align = false );


		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();
	}

    protected function register_controls() {

        $this->register_query_builder_controls();
        $this->register_content_section_1();
		$this->register_content_section_2();
		$this->register_style_section_1();

        $this->register_carousel_controls();
        $this->register_style_carousel_controls();

    }

	protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}

		$settings = $this->get_settings_for_display();
		$widget_id = $this->get_id();
		$element_id = $settings['_element_id'];
		$query = $this->get_query_result();

		if ( ! $query->found_posts ) {
			?>
				<div class="nothing-show">
					<h2><?php esc_html_e( 'Nothing found!', THEME_NAME ); ?></h2>
					<p><?php esc_html_e( 'It looks like nothing was found here!', THEME_NAME ); ?></p>
				</div>
				<?php
				return;
		}

		// Get selected view from URL parameters
        if( isset( $_GET['view'] )){
            $selected_view = sanitize_text_field( $_GET['view'] );
            if( $selected_view == 'grids'){
				$hover_class = $settings['grid_view_hover'];
                $selected_layout = $settings['grid_view_layout'];
            }
			if ( $selected_view == 'list' ) {
                $hover_class = $settings['list_view_hover'];
                $selected_layout = $settings['list_view_layout'];
			}
        }
        else{
            $selected_view = $settings['layout'];
            $selected_layout = $settings['posts_layout'];
			$hover_class = $settings['hover'];
        }

        if ( $settings['show_grid_list_toggle'] === 'yes' ) {
		    ?>
		    <div class="switcher-container d-flex align-items-center justify-content-start">
                <a href="?view=list">
                    <div class="list-icon d-flex align-items-center justify-content-center <?php echo ( $selected_view === 'list' ) ? 'active' : ''; ?>">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['list-icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    </div>
                </a>
                <a href="?view=grids">
                    <div class="grid-icon d-flex align-items-center justify-content-center <?php echo ( $selected_view === 'grids' ) ? 'active' : ''; ?>">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['grid-icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    </div>
                </a>
            </div>
			<?php
		}
        ?>
        <div class="theme-posts-container theme-post-widget">
            <?php
                $post_wrapper_cls = '';
                if ( $selected_view !== 'carousel') {
                    $kind = 'grid';
                    $post_wrapper_cls = 'theme-posts-wrapper';
                }
                else{
                    $kind = 'carousel';
                }
                ?>
				<div class="<?php echo $post_wrapper_cls ?> layout-<?php echo $kind ?> view-<?php echo $selected_view ?>">
					<?php $this->render_carousel_header(); ?>
					<?php
					if ( $query->have_posts() ) :
						while ( $query->have_posts() ) :
							$query->the_post();

							$post_item_cls = 'post-item';
							if ( $selected_view == 'carousel' ) {
								$post_item_cls = ' swiper-slide';
							}

							?>
							<div class="<?php echo esc_html( $post_item_cls ); ?>">
								<article <?php post_class( array( 'post-wrapper', 'cart-hover-' . $hover_class ) ); ?>>
									<?php
									if ( $selected_layout ) {
										echo show_template( $selected_layout );
									}
									?>
								</article>
							</div>
							<?php
						endwhile;
					endif;
					wp_reset_postdata();
					?>
					<?php $this->render_carousel_footer(); ?>
                </div>
            </div>
		<?php $this->render_pagination();

        if($this->theme_is_edit_mode() and $settings['show_grid_list_editor'] === 'yes' and $settings['show_grid_list_toggle'] === 'yes'){
			$selected_view = 'grids';
			$selected_layout = $settings['grid_view_layout'];
            $kind = 'grid';
            $post_wrapper_cls = 'theme-posts-wrapper';
			$hover_class = $settings['grid_view_hover'];
            ?>
            <div class="theme-posts-container theme-post-widget">
                <?php echo __( 'grid view', THEME_NAME ); ?>
                    <div class="<?php echo $post_wrapper_cls ?> layout-<?php echo $kind ?> view-<?php echo $selected_view ?>">
                        <?php
                        if ( $query->have_posts() ) :
                            while ( $query->have_posts() ) :
                                $query->the_post();

                                $post_item_cls = 'post-item';
                                if ( $selected_view == 'carousel' ) {
                                    $post_item_cls = ' swiper-slide';
                                }

                                ?>
                                <div class="<?php echo esc_html( $post_item_cls ); ?>">
                                    <article <?php post_class( array( 'post-wrapper', 'cart-hover-' . $hover_class ) ); ?>>
                                        <?php
                                        if ( $selected_layout ) {
                                            echo show_template( $selected_layout );
                                        }
                                        ?>
                                    </article>
                                </div>
                                <?php
                            endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
            <?php
        }
        if($this->theme_is_edit_mode() and $settings['show_list_list_editor'] === 'yes' and $settings['show_grid_list_toggle'] === 'yes'){
			$selected_view = 'list';
			$selected_layout = $settings['list_view_layout'];
            $kind = 'grid';
            $post_wrapper_cls = 'theme-posts-wrapper';
			$hover_class = $settings['list_view_hover'];
            ?>
            <div class="theme-posts-container theme-post-widget">
                <?php echo __( 'list view', THEME_NAME ); ?>
                    <div class="<?php echo $post_wrapper_cls ?> layout-<?php echo $kind ?> view-<?php echo $selected_view ?>">
                        <?php
                        if ( $query->have_posts() ) :
                            while ( $query->have_posts() ) :
                                $query->the_post();

                                $post_item_cls = 'post-item';
                                if ( $selected_view == 'carousel' ) {
                                    $post_item_cls = ' swiper-slide';
                                }

                                ?>
                                <div class="<?php echo esc_html( $post_item_cls ); ?>">
                                    <article <?php post_class( array( 'post-wrapper', 'cart-hover-' . $hover_class ) ); ?>>
                                        <?php
                                        if ( $selected_layout ) {
                                            echo show_template( $selected_layout );
                                        }
                                        ?>
                                    </article>
                                </div>
                                <?php
                            endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
            <?php
        } ?>
		<script>
			jQuery( document ).ready( function ( $ )
			{
				var carouselPosts = $( '.theme-carousel-<?php echo $this->get_id() ?>' );

				carouselPosts.each(function() {
					// Get all elements with the class '.theme-posts-carousel-wrapper'
					var carouselSettings = $( this ).data( 'settings' );

					// Find the swiper container within the current carousel
					var carouselContainer = $( this ).find( '.swiper-container' )[ 0 ];

					// Initialize Swiper for the current carousel
					var swiper<?php echo $element_id;
					echo $widget_id; ?> = new Swiper( carouselContainer, carouselSettings );
					$( '.swiper-prev-btn<?php echo $element_id ?>' ).on( 'click', function ()
					{
						if ( swiper<?php echo $element_id;
						echo $widget_id; ?>.activeIndex > 0 )
						{
							swiper<?php echo $element_id;
							echo $widget_id; ?>.slidePrev();
						}
					} );

					$( '.swiper-next-btn<?php echo $element_id ?>' ).on( 'click', function ()
					{
						if ( swiper<?php echo $element_id;
						echo $widget_id; ?>.activeIndex < swiper<?php echo $element_id;
						  echo $widget_id; ?>.slides.length - 1 )
						{
							swiper<?php echo $element_id;
							echo $widget_id; ?>.slideNext();
						}
					} );
				});
			} );
		</script>
		<?php
		
	}


}