<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_sell_count extends \Elementor\Widget_Base {

    use basic_element;

    public function get_name() {
        return 'ar_woo_product_sell_count';
    }

    public function get_title() {
        return esc_html__('product sell count', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_sell_count';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

	protected function register_style_section_1() {
		$this->start_controls_section(
			'section_style_text',
			[ 
				'label' => esc_html__( 'texts', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'text', 'p', $align = false );

		$this->end_controls_section();

	}

    protected function register_controls() {

		$this->register_style_section_1();
    }

    protected function render() {
		$product_id = get_the_ID();
		$sales_count = get_post_meta( $product_id, 'total_sales', true );
		if ( $this->theme_is_edit_mode() ) {
			echo ( '<p>226</p>' );
		} else {
			echo ( '<p>' . $sales_count . '</p>' );
		}
    }

}