<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_product_quantity extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_product_quantity';
    }

    public function get_title() {
        return esc_html__('product quantity', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_product_quantity';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'login_form_style_section',
            [
                'label' => esc_html__( 'product title', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('theme_product_title',  '.theme-product-quantity');

        $this->end_controls_section();
    } 


    protected function register_controls() {

        $this->register_style_section_1();
    }

	protected function render() {
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
		if ( $this->theme_is_edit_mode() ) {
			echo '<p class="theme-product-quantity">123</p>';
		} else {
			global $post;
			$product_id = get_the_ID();
			$product = wc_get_product( $product_id );
			if ( $product ) {
                if( $product->is_type( 'variable' )){
                    $variations = $product->get_children();
                    $total_stock_quantity = 0;
    
                    foreach ( $variations as $variation_id ) {
                        $variation = wc_get_product( $variation_id );
                        $stock_quantity = $variation->get_stock_quantity();
    
                        if ( $stock_quantity ) {
                            $total_stock_quantity += $stock_quantity;
                        }
                    }
                    echo '<p class="theme-product-quantity">' . esc_html( $total_stock_quantity ) . '</p>';
                } else {
                    if ( $product ) {
                        $stock_quantity = $product->get_stock_quantity();
                        if( $stock_quantity == null){
							$stock_quantity = 0;
                        }
                        echo '<p class="theme-product-quantity">' . esc_html( $stock_quantity ) . '</p>';
                    }
                }
            }
		}
	}

}