<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_woo_cart_total extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_woo_cart_total';
    }

    public function get_title() {
        return esc_html__('cart total', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_woo_cart_total';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'cart_table',
		    [
			    'label' => esc_html__('table', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

        $this->register_table_style('cart_table', '.shop_table');
        $this->end_controls_section();
    }

	protected function register_style_section_2() {
		$this->start_controls_section(
			'produt-name',
			[ 
				'label' => esc_html__( 'produt', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'produt-name', '.product-name', $align = false );

		$this->add_control(
			'product-price-sep',
			[ 
				'label' => esc_html__( 'product total', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'produt-total', '.product-total', $align = false );

		$this->end_controls_section();
	}

	protected function register_style_section_3() {
		$this->start_controls_section(
			'order-sub-total',
			[ 
				'label' => esc_html__( 'order sub total', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->register_text_style( 'order-sub-total', '.cart-subtotal th', $align = false );

		$this->add_control(
			'product-sub-total-sep',
			[ 
				'label' => esc_html__( 'total', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'price-sub-total', '.cart-subtotal td', $align = false );

		$this->end_controls_section();
	}

    protected function register_style_section_4() {
        $this->start_controls_section(
            'order_total',
		    [
			    'label' => esc_html__('order total', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

		$this->register_container_style( 'total_price_name', '.total-amounts' );

		$this->add_control(
			'product-total-label-sep',
			[ 
				'label' => esc_html__( 'total', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('total_price_name', '.total-amounts .total-name', $align = false);

		$this->add_control(
			'product-total-sep',
			[ 
				'label' => esc_html__( 'total', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'total_price_value', '.total-amounts .total-amount', $align = false );

        $this->end_controls_section();
    }
    
    protected function register_style_section_5() {
        $this->start_controls_section(
            'button',
		    [
			    'label' => esc_html__('button ', THEME_NAME),
			    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
		    ]
	    );

        $this->register_text_style('button',  '.checkout-button', $align=false);
        $this->end_controls_section();
    }


	protected function register_controls() {

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
        $this->register_style_section_4();
		$this->register_style_section_5();
    }

    protected function render(){
		if ( ! class_exists( 'woocommerce' ) ) {
			return false;
		}
        if ( $this->theme_is_edit_mode()) {
            ?>
            <table class="shop_table woocommerce-checkout-review-order-table">
                <thead>
                    <tr>
                        <th class="product-name">محصول</th>
                        <th class="product-total">جمع جزء</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="cart_item">
                        <td class="product-name">دوره تارگتینگ&nbsp; <strong class="product-quantity">×&nbsp;3</strong></td>
                        <td class="product-total">
                            <span class="woocommerce-Price-amount amount">
                                <bdi>12،000،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
                            </span>
                        </td>
                    </tr>
                    <tr class="cart_item">
                        <td class="product-name">برند سازی&nbsp; <strong class="product-quantity">×&nbsp;2</strong></td>
                        <td class="product-total">
                            <span class="woocommerce-Price-amount amount">
                                <bdi>2،400،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
                            </span>
                        </td>
                    </tr>
                </tbody>
                <tfoot>
                    <tr class="cart-subtotal">
                        <th>جمع جزء</th>
                        <td>
                            <span class="woocommerce-Price-amount amount">
                                <bdi>14،400،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
                            </span>
                        </td>
                    </tr>
                </tfoot>
            </table>
            <div class="total-amounts">
                <span class="total-name">مجموع</span>
                <span class="total-amount">
                    <strong>
                        <span class="woocommerce-Price-amount amount">
                            <bdi>14،400،000&nbsp;<span class="woocommerce-Price-currencySymbol">تومان</span></bdi>
                        </span>
                    </strong>
                </span>
            </div>

            <div class="wc-proceed-to-checkout">
                <a href="../checkout/" class="checkout-button button alt wc-forward"> ادامه جهت تسویه حساب</a>
            </div>

            <?php
        }
        else{
            
            ?>
            <div class="cart_totals <?php echo ( WC()->customer->has_calculated_shipping() ) ? 'calculated_shipping' : ''; ?>">

            <?php do_action( 'woocommerce_before_cart_totals' ); ?>
            
            <table class="shop_table woocommerce-checkout-review-order-table">
                <thead>
                    <tr>
                        <th class="product-name"><?php esc_html_e( 'Product', 'woocommerce' ); ?></th>
                        <th class="product-total"><?php esc_html_e( 'Subtotal', 'woocommerce' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    do_action( 'woocommerce_review_order_before_cart_contents' );

                    foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                        $_product = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );

                        if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
                            ?>
                            <tr class="<?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
                                <td class="product-name">
                                    <?php echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key ) ) . '&nbsp;'; ?>
                                    <?php echo apply_filters( 'woocommerce_checkout_cart_item_quantity', ' <strong class="product-quantity">' . sprintf( '&times;&nbsp;%s', $cart_item['quantity'] ) . '</strong>', $cart_item, $cart_item_key ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                                    <?php echo wc_get_formatted_cart_item_data( $cart_item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                                </td>
                                <td class="product-total">
                                    <?php echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                                </td>
                            </tr>
                            <?php
                        }
                    }

                    do_action( 'woocommerce_review_order_after_cart_contents' );
                    ?>
                </tbody>
                <tfoot>

                    <tr class="cart-subtotal">
                        <th><?php esc_html_e( 'Subtotal', 'woocommerce' ); ?></th>
                        <td><?php wc_cart_totals_subtotal_html(); ?></td>
                    </tr>

                    <?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
                        <tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
                            <th><?php wc_cart_totals_coupon_label( $coupon ); ?></th>
                            <td><?php wc_cart_totals_coupon_html( $coupon ); ?></td>
                        </tr>
                    <?php endforeach; ?>

                    <?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>
					
						<?php do_action( 'woocommerce_cart_totals_before_shipping' ); ?>
					
						<?php wc_cart_totals_shipping_html(); ?>
					
						<?php do_action( 'woocommerce_cart_totals_after_shipping' ); ?>
					
					<?php elseif ( WC()->cart->needs_shipping() && 'yes' === get_option( 'woocommerce_enable_shipping_calc' ) ) : ?>
					
						<tr class="shipping">
							<th><?php esc_html_e( 'Shipping', 'woocommerce' ); ?></th>
							<td data-title="<?php esc_attr_e( 'Shipping', 'woocommerce' ); ?>"><?php woocommerce_shipping_calculator(); ?></td>
						</tr>
					
					<?php endif; ?>

                    <?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
                        <tr class="fee">
                            <th><?php echo esc_html( $fee->name ); ?></th>
                            <td><?php wc_cart_totals_fee_html( $fee ); ?></td>
                        </tr>
                    <?php endforeach; ?>

                    <?php if ( wc_tax_enabled() && ! WC()->cart->display_prices_including_tax() ) : ?>
                        <?php if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) : ?>
                            <?php foreach ( WC()->cart->get_tax_totals() as $code => $tax ) : // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited ?>
                                <tr class="tax-rate tax-rate-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
                                    <th><?php echo esc_html( $tax->label ); ?></th>
                                    <td><?php echo wp_kses_post( $tax->formatted_amount ); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <tr class="tax-total">
                                <th><?php echo esc_html( WC()->countries->tax_or_vat() ); ?></th>
                                <td><?php wc_cart_totals_taxes_total_html(); ?></td>
                            </tr>
                        <?php endif; ?>
                    <?php endif; ?>

                    <?php do_action( 'woocommerce_review_order_before_order_total' ); ?>
                    
                </tfoot>
            </table>
            <div class="total-amounts">
                <span class="total-name"><?php esc_html_e( 'Total cart', THEME_NAME ); ?></span>
                <span class="total-amount"><?php wc_cart_totals_order_total_html(); ?></span>
            </div>
            <?php do_action( 'woocommerce_review_order_after_order_total' ); ?>
                        
            <div class="wc-proceed-to-checkout">
                <?php do_action( 'woocommerce_proceed_to_checkout' ); ?>
            </div>
            	<?php do_action( 'woocommerce_after_cart_totals' ); ?>
                
                </div>
            <?php
        }        
	}
}