<?php

use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_search extends \Elementor\Widget_Base {

    use basic_element;

    public function get_name() {
        return 'ar_search';
    }

    public function get_title() {
        return esc_html__('Search', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_search';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1(){
        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__('Settings', THEME_NAME),
            ]
        );

        $this->add_control(
            'search_type',
            [
                'label' => esc_html__( 'Search Type', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'popup',
                'options' => [
                    'popup'  => esc_html__( 'Popup', THEME_NAME ),
                    'inline' => esc_html__( 'Inline', THEME_NAME ),
                ],
            ]
        );

        $this->add_control(
            'popup_style',
            [
                'label' => esc_html__( 'Popup Style', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                    'style-1'  => esc_html__( 'Style 1', THEME_NAME ),
                    'style-2'  => esc_html__( 'Style 2', THEME_NAME ),
                ],
                'condition' => ['search_type' => 'popup'],
            ]
        );

        $this->add_control(
            'inline_btn_title',
            [
                'label' => esc_html__( 'Button Title', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => ['search_type' => 'inline'],
            ]
        );

        $this->add_responsive_control(
            'text_align', [
                'label' => esc_html__('Alignment', THEME_NAME),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [

                    'left' => [
                        'title' => esc_html__('Left', THEME_NAME),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', THEME_NAME),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', THEME_NAME),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .popup-search-opener-wrapper' => 'justify-content: {{VALUE}};',
                    '{{WRAPPER}} .inline-search-form-wrapper' => 'text-align: {{VALUE}};'
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Button', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_container_style('Button', '.inline-search-form .submit');

		$this->add_responsive_control(
			'btn-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('Button-text', '.inline-search-form .submit p', $align=false);

		$this->add_responsive_control(
			'btn-icon',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->register_text_style('Button-icon', '.inline-search-form .submit i', $align=false);
        
        

        $this->end_controls_section();
    }

    protected function register_style_section_2() {
        $this->start_controls_section(
            'section_inline_form_style',
            [
                'label' => esc_html__('Form', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['search_type' => 'inline'],
            ]
        );

        $this->add_control(
            'inline_form_width',
            [
                'label' => esc_html__('Width', THEME_NAME),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 150,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .inline-search-form' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'inline_input_padding',
            [
                'label' => esc_html__('Padding', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .inline-search-form .search-field' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'inline_form_border',
                'label' => esc_html__( 'Border', THEME_NAME ),
                'selector' => '{{WRAPPER}} .inline-search-form .search-field' ,
            ]
        );

        $this->add_control(
            'inline_form_border_radius',
            [
                'label' => esc_html__( 'Border Radius', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .inline-search-form .search-field' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'inline_form_color',
            [
                'label' => esc_html__('Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .inline-search-form .search-field' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'inline_form_placeholder_color',
            [
                'label' => esc_html__('Placeholder Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .inline-search-form .search-field::-webkit-input-placeholder, {{WRAPPER}} .inline-search-form .search-field::placeholder' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'search_field_bg',
            [
                'label' => esc_html__('Background', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .inline-search-form .search-field' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'inline_form_box_shadow',
                'label' => esc_html__( 'Box Shadow', THEME_NAME ),
                'selector' => '{{WRAPPER}} .inline-search-form',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'inline_form_search_field_typography',
                'label' => esc_html__('Typography', THEME_NAME),
                'selector' => '{{WRAPPER}} .inline-search-form .search-field',
            ]);

        $this->end_controls_section();
    }

    protected function register_style_section_3() {
        $this->start_controls_section(
            'section_popup_container_style',
            [
                'label' => esc_html__('Popup Container', THEME_NAME),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['search_type' => 'popup'],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'popup_container_bg',
                'label' => esc_html__('Background', THEME_NAME),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .popup-search .popup-search-container',
            ]
        );

        $this->add_control(
            'popup_container_closer_color',
            [
                'label' => esc_html__('Closer Button Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-closer' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'popup_container_title_color',
            [
                'label' => esc_html__('Title Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-title-wrapper h3' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'popup_container_title_typography',
                'label' => esc_html__('Title Typography', THEME_NAME),
                'selector' => '{{WRAPPER}} .popup-search-title-wrapper h3',
            ]);


        $this->add_control(
            'popup_container_form_width',
            [
                'label' => esc_html__('Form Width', THEME_NAME),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 150,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .popup-search-form-wrapper' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'popup_container_form_padding',
            [
                'label' => esc_html__('Padding', THEME_NAME),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .popup-search-form .search-field' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'popup_container_form_border',
                'label' => esc_html__( 'Border', THEME_NAME ),
                'selector' => '{{WRAPPER}} .popup-search-form .search-field',
            ]
        );

        $this->add_control(
            'popup_container_form_border_radius',
            [
                'label' => esc_html__( 'Border Radius', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .popup-search-form .search-field' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'popup_container_input_color',
            [
                'label' => esc_html__('Form Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-form .search-field' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'popup_container_placeholder_color',
            [
                'label' => esc_html__('Placeholder Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-form .search-field::-webkit-input-placeholder, {{WRAPPER}} .popup-search-form .search-field::placeholder' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'popup_container_input_bg',
            [
                'label' => esc_html__('Form Background', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-form .search-field' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'popup_container_form_icon_color',
            [
                'label' => esc_html__('Icon Color', THEME_NAME),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popup-search-form .submit' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
    }

	protected function register_style_section_4() {
		$this->start_controls_section(
			'icon-style-section',
			[ 
				'label' => esc_html__( 'icon style', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [ 'search_type' => 'popup' ],
			]
		);

		$this->register_text_style( 'icon', '.popup-search-opener i' );

		$this->end_controls_section();
	}

    protected function register_controls(){

        $this->register_content_section_1();

        $this->register_style_section_1();
        $this->register_style_section_2();
        $this->register_style_section_3();
		$this->register_style_section_4();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $search_type = ( isset($settings['search_type']) && $settings['search_type'] == 'inline' )? 'inline' : 'popup';
        ?>
        <?php if($search_type == 'popup'): ?>
        <?php $style = ( !empty($settings['popup_style']) )? $settings['popup_style'] : 'style-1'; ?>
        <div class="popup-search-wrapper <?php echo esc_html($style); ?>">
            <div class="popup-search-opener-wrapper">
                <span class="popup-search-opener"><i class="isax isax-search-normal-1"></i></span>
            </div>
            <div class="popup-search">
                <div class="popup-search-container">
                    <span class="popup-search-closer"></span>
                    <div class="popup-search-content">
                        <div class="popup-search-title-wrapper">
                            <h3><?php esc_html_e('Type and hit Enter to search', THEME_NAME); ?></h3>
                        </div>
                        <div class="popup-search-form-wrapper">
                            <form action="<?php echo home_url('/'); ?>" method="get" class="popup-search-form">
                                <input type="text" name="s" value="" class="search-field" placeholder="<?php esc_html_e('Search ...', THEME_NAME); ?>" aria-label="Search" required>
                                <button type="submit" class="submit" aria-label="Submit">
                                    <i class="isax isax-search-normal-1"></i>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php else: ?>
        <div class="inline-search-form-wrapper">
            <form action="<?php echo home_url('/'); ?>" method="get" class="inline-search-form">
                <input type="text" name="s" value="" class="search-field" placeholder="<?php esc_html_e('Search ...', THEME_NAME); ?>" aria-label="Search" required>
                <button type="submit" class="submit" aria-label="Submit">
                    <i class="isax isax-search-normal-1"></i>
                    <p><?php echo($settings['inline_btn_title']);?></p>
                </button>
            </form>
        </div>
        <?php endif;
    }

}