<?php

use handler\basic_element;

class ar_register extends \Elementor\Widget_Base {

    use basic_element;

    public function get_name() {
        return 'ar_register';
    }

    public function get_title() {
        return __('register Widget', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_register';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1(){
        $this->start_controls_section(
            'login_form_labels_section',
            [
                'label' => __( 'register Form Labels', THEME_NAME ),
            ]
        );

        $this->add_control(
            'username_label',
            [
                'label' => __( 'Username Label', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Username', THEME_NAME ),
            ]
        );

		$this->add_control(
			'username_placeholder',
			[ 
				'label' => __( 'Username placeholder', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Username', THEME_NAME ),
			]
		);

        $this->add_control(
            'email_label',
            [
                'label' => __( 'email Label', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'email', THEME_NAME ),
            ]
        );

		$this->add_control(
			'email_placeholder',
			[ 
				'label' => __( 'email placeholder', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'email', THEME_NAME ),
			]
		);

		$this->add_control(
			'password_label',
			[ 
				'label' => __( 'password Label', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'password', THEME_NAME ),
			]
		);

		$this->add_control(
			'registered_text',
			[ 
				'label' => __( 'registered text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'didnt register?', THEME_NAME ),
			]
		);

		$this->add_control(
			'password_placeholder',
			[ 
				'label' => __( 'Password placeholder', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Password', THEME_NAME ),
			]
		);

        $this->add_control(
            'reset_password',
            [
                'label' => __( 'reset password?', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'reset Password', THEME_NAME ),
            ]
        );

		$this->add_control(
			'login_text',
			[ 
				'label' => __( 'login text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'login', THEME_NAME ),
			]
		);

		$this->add_control(
			'login_link',
			[ 
				'label' => __( 'login link', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
			]
		);

		$this->add_control(
			'register_text',
			[ 
				'label' => __( 'register text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'register', THEME_NAME ),
			]
		);

        $this->end_controls_section();
    }


    protected function register_style_section_1() {
        $this->start_controls_section(
            'login_form_style_section',
            [
                'label' => __( 'register Form Styles', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->register_text_style('inputs',  'input');

        $this->add_control(
			'labels',
			[
				'label' => esc_html__( 'labels', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->register_text_style('labels',  'label', $align=false);
        
        $this->end_controls_section();
    }

	protected function register_style_section_2() {
		$this->start_controls_section(
			'other_form_style_section',
			[ 
				'label' => __( 'other text Styles', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'links',
			[ 
				'label' => esc_html__( 'links', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'login_link', '.login-link', $align = false );

		$this->add_control(
			'texts',
			[ 
				'label' => esc_html__( 'texts', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'login_text', '.login-text', $align = false );

		$this->add_control(
			'btn',
			[ 
				'label' => esc_html__( 'buttom', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'login_btn', '.button', $align = false );

		$this->add_control(
			'policy',
			[ 
				'label' => esc_html__( 'policy', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'policy', '.woocommerce-privacy-policy-text p', $align = false );

		$this->add_control(
			'icons',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->register_text_style( 'isax', '.isax', $align = false );

		$this->end_controls_section();
	}

    protected function register_controls() {

        $this->register_content_section_1();

        $this->register_style_section_1();
		$this->register_style_section_2();

    }

    
    protected function render2() {
        $settings = $this->get_settings_for_display();
        ?>
        <form id="registerform" action="<?php echo esc_url( wp_registration_url() ); ?>" method="post">
            <p>
                <label for="user_login"><?php echo esc_html( $settings['username_label'] ); ?></label><br />
                <input type="text" name="user_login" id="user_login" class="input" value="" size="20" />
            </p>
            <p>
                <label for="user_email"><?php echo esc_html( $settings['email_label'] ); ?></label><br />
                <input type="email" name="user_email" id="user_email" class="input" value="" size="25" />
            </p>
            <input type="hidden" name="redirect_to" value="<?php echo esc_url( home_url() ); ?>" />
            <?php do_action( 'register_form' ); ?>

            <div class="form-register">
                <?php if ( $settings['registered_text'] ) { ?>
					<p class="login-text">
						<?php echo esc_attr( $settings['registered_text'] ); ?>
					</p>
				<?php }
				if ( $settings['login_link'] ) { ?>
					<a class="login-link"
						href="<?php echo esc_attr( $settings['login_link']['url'] ); ?>"><?php echo esc_attr( $settings['login_text'] ); ?></a>
				<?php } ?>
            </div>

            <p class="submit">
                <input type="submit" name="submit" class="button button-primary" value="<?php esc_attr_e( 'register', THEME_NAME ); ?>" />
            </p>
        </form>
        <?php
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        do_action('woocommerce_before_customer_login_form'); ?>
        <div class="login-form-container">
            <form method="post" <?php do_action('woocommerce_register_form_tag'); ?>>
                <?php do_action('woocommerce_register_form_start'); ?>

                <div class="form-group">
                    <div class="input-group">
                        <label for="reg_email"><?php echo esc_html( $settings['email_label'] ); ?>&nbsp;<span class="required">*</span></label>
                        <div class="input-container">
                            <input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" autocomplete="email"
                                    placeholder="<?php echo esc_attr( $settings['email_placeholder'] ); ?>"
                                    value="<?php echo (!empty($_POST['email'])) ? esc_attr(wp_unslash($_POST['email'])) : ''; ?>"/>
                            <span class="input-group-text">
                                <i class="isax isax-sms4"></i>
                            </span>
                        </div>
                    </div>
                    
                </div>


                <?php if ( get_option( 'woocommerce_registration_generate_username' ) === 'no' ) { ?>

                    <div class="form-group">
                        <div class="input-group">
                            <label for="reg_username"><?php echo esc_html( $settings['username_label'] ); ?>&nbsp;<span class="required">*</span></label>
                            <div class="input-container">
                                <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" autocomplete="username"
                                        placeholder="<?php echo esc_attr( $settings['username_placeholder'] ); ?>"
                                        value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>"/>
                                <span class="input-group-text">
                                    <i class="isax isax-user4"></i>
                                </span>
                            </div>
                        </div>
                        
                    </div>

                <?php } 

                
                if ( get_option( 'woocommerce_registration_generate_password' ) === 'no' ) { ?>

                    <div class="form-group">
                        <div class="input-group">
                            <label for="reg_password"><?php echo esc_attr( $settings['password_label'] ); ?>&nbsp;<span class="required">*</span></label>
                            <div class="input-container">
                                <input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" placeholder="<?php echo esc_attr( $settings['password_placeholder'] ); ?>"/>
                                <span class="input-group-text toggle-password">
                                    <i class="isax isax-eye"></i>
                                </span>
                            </div>
                        </div>
                    </div>

                <?php } 
                
                do_action('woocommerce_register_form'); ?>

                <div class="form-meta">
                    <?php
					if ( $settings['reset_password'] ) { ?>
				
						<div class="form-reset">
							<a class="login-link"
								href="../my-account/lost-password/"><?php echo esc_attr( $settings['reset_password'] ); ?></a>
						</div>
					<?php } ?>
                </div>

                <div class="form-register">
                    <?php if ( $settings['registered_text'] ) { ?>
                        <p class="login-text">
                            <?php echo esc_attr( $settings['registered_text'] ); ?>
                        </p>
                    <?php }
                    if ( $settings['login_link'] ) { ?>
                        <a class="login-link"
                            href="<?php echo esc_attr( $settings['login_link']['url'] ); ?>"><?php echo esc_attr( $settings['login_text'] ); ?></a>
                    <?php } ?>
                </div>

                <div class="woocommerce-form-row form-row">
                    <?php wp_nonce_field('woocommerce-register', 'woocommerce-register-nonce'); ?>
                    <button type="submit" class="button button-primary" name="register" value="<?php esc_attr_e('Register', 'woocommerce'); ?>">
                        <?php echo esc_attr( $settings['register_text'] ); ?>
                    </button>
                </div>

                <?php do_action('woocommerce_register_form_end'); ?>

            </form>
        </div>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
            var togglePassword = document.querySelector('.toggle-password');
            var passwordInput = document.getElementById('user_pass');
            var passwordIcon = togglePassword.querySelector('i');
            togglePassword.addEventListener('click', function() {
                if (passwordInput.type === 'password') {
                    passwordInput.type = 'text';
                    passwordIcon.classList.remove('isax-eye');
                    passwordIcon.classList.add('isax-eye-slash4');
                } else {
                    passwordInput.type = 'password';
                    passwordIcon.classList.remove('isax-eye-slash4');
                    passwordIcon.classList.add('isax-eye');
                }
            });
        });
        </script>

        <?php do_action('woocommerce_after_customer_login_form'); ?>
        <?php
    }
}