<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_profile_btn extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_profile_btn';
    }

    public function get_title() {
        return esc_html__('profile button', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_profile_btn';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1(){

        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__( 'Button Title', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Button Icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

		$this->add_control(
			'link',
			[ 
				'label' => esc_html__( 'link', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::URL,
			]
		);


		$this->end_controls_section();

    }

	protected function register_content_section_2() {

		$this->start_controls_section(
			'section_content_menu',
			[ 
				'label' => esc_html__( 'menu', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title',
			[ 
				'label' => esc_html__( 'Title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'icon',
			[ 
				'label' => esc_html__( 'Icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

		$repeater->add_control(
			'link',
			[ 
				'label' => esc_html__( 'link', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::URL,
			]
		);

		$this->add_control(
			'menu_items',
			[ 
				'label' => esc_html__( 'Items', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
                'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'logout',
			[ 
				'label' => esc_html__( 'enable logout', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'logout-icon',
			[ 
				'label' => esc_html__( 'logout Icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'condition' => [ 
					'logout' => 'yes',
				],
			]
		);

		$this->add_control(
			'logout-title',
			[ 
				'label' => esc_html__( 'logout Title', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [ 
					'logout' => 'yes',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_style_section_1() {
        $this->start_controls_section(
            'btn-text',
            [
                'label' => esc_html__( 'text', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->register_text_style( 'btn_box', '.user-name', $align = false );

        $this->add_control(
            'text',
            [
                'label'     => esc_html__( 'text', THEME_NAME ),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

		$this->register_text_style( 'btn_text', '.user-name p', $align = false );

		$this->add_control(
			'icon-heading',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

        $this->register_text_style('btn_icon',  '.user-name i', $align=false);

        $this->end_controls_section();

    }


	protected function register_style_section_2() {
		$this->start_controls_section(
			'menu-items',
			[ 
				'label' => esc_html__( 'menu items', THEME_NAME ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'items-container',
			[ 
				'label' => esc_html__( 'container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->register_container_style( 'single-share-box-container', '.single-share-box-container' );


		$this->add_control(
			'item-container',
			[ 
				'label' => esc_html__( 'item container', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->register_container_style( 'single-share-box-container', '.single-share-box-container a' );

		$this->start_controls_tabs( 'btn-text-style' );

		$this->start_controls_tab(
			'text-normal',
			[ 
				'label' => esc_html__( 'normal', THEME_NAME ),
			]
		);

		$this->add_control(
			'item-text',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item_text', '.single-share-box-container p', $align = false );

		$this->add_control(
			'item-icon-heading',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item_icon', '.single-share-box-container i', $align = false );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'text-hover',
			[ 
				'label' => esc_html__( 'hover', THEME_NAME ),
			]
		);

		$this->add_control(
			'item-text-hover',
			[ 
				'label' => esc_html__( 'text', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item_text-hover', '.single-share-box-container a:hover p', $align = false );

		$this->add_control(
			'icon-heading-hover',
			[ 
				'label' => esc_html__( 'icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->register_text_style( 'item_icon-hover', '.single-share-box-container a:hover i', $align = false );

		$this->end_controls_tab();
		$this->end_controls_tabs();
        
        $this->end_controls_section();

	}

	protected function register_controls() {
        $this->register_content_section_1();
		$this->register_content_section_2();
        $this->register_style_section_1();
		$this->register_style_section_2();
    }

    protected function render() {
		$settings = $this->get_settings_for_display();
		if ( is_user_logged_in() ) {
			$current_user = wp_get_current_user();
			?>
                <div class="box-share-btn">
                    <a href="<?php echo wc_get_account_endpoint_url( 'edit-account' ); ?>" class="d-flex align-items-center user-name">
                        <p class="user-text"><?php echo esc_html__(  'Hi ', THEME_NAME) . $current_user->display_name ; ?></p>
                    </a>
                    <?php if($settings['menu_items']){?>
                    <div class="single-share-box-container mt-4">
                        <?php
						foreach ( $settings['menu_items'] as $item ) {
							$this->add_link_attributes( $item['title'], $item['link'] );
							$this->add_render_attribute( $item['title'], 'class', "theme-advanced-heading-link" );

							echo '<a class="d-flex flex-row align-content-center" ';
							$this->print_render_attribute_string( $item['title'] );
							echo '>';
                            \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] );
                            ?>
                            <p class="share-text"><?php echo esc_html($item['title']);?></p>
                            <?php 
                            echo '</a>';
						}
                        ?>     
                        <?php if($settings['logout'] == 'yes'){
                            echo '<a class="d-flex flex-row align-content-center" href="';
							echo wp_logout_url();
							echo '">';
                            \Elementor\Icons_Manager::render_icon( $settings['logout-icon'], [ 'aria-hidden' => 'true' ] );
                            ?>
                            <p class="share-text"><?php echo esc_html($settings['logout-title']);?></p>
                            <?php 
                            echo '</a>';
                        }
                        ?>
                     </div>
                     <?php }?>
                </div>
				<?php
		} else {
			?>
            <a href="<?php echo esc_url( $settings['link']['url'] ); ?>" class="d-flex align-items-center user-name">
                <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                <p class="user-text"><?php echo esc_html( $settings['btn_title'] ); ?></p>
            </a>
            <?php
		}
	}
}