<?php


use handler\basic_element;

if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly


class ar_post_page_link extends \Elementor\Widget_Base {

    use basic_element;


    public function get_name() {
        return 'ar_post_page_link';
    }

    public function get_title() {
        return esc_html__('page link', THEME_NAME);
    }

    public function get_icon() {
        return 'ar_post_page_link';
    }

    public function get_categories() {
        return ['core-elementor-elements'];
    }

    protected function register_content_section_1() {
        $this->start_controls_section(
            'texts',
            [
                'label' => __( 'text', THEME_NAME ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,

            ]
        );

        $this->add_control(
            'text',
            [
                'label' => __( 'text', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', THEME_NAME ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

         $this->end_controls_section();
    }

    protected function register_style_section_1() {
        $this->start_controls_section(
            'post_style_section',
            [
                'label' => esc_html__( 'style', THEME_NAME ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
			'style_tabs'
		);

		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__( 'normal', THEME_NAME ),
			]
		);

        
        $this->register_text_style('text',  'button', $align=false);

        $this->add_control(
            'icon_sep',
            [
                'label' => esc_html__( 'icon', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        ); 

        $this->register_text_style('icon',  'i', $align=false);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_active_tab',
			[
				'label' => esc_html__( 'active', THEME_NAME ),
			]
		);

        $this->register_text_style('text_active',  'button:hover', $align=false);

        $this->add_control(
            'icon_sep_active',
            [
                'label' => esc_html__( 'icon', THEME_NAME ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        ); 

        $this->register_text_style('icon_active',  'i:hover', $align=false);

		$this->end_controls_tab();

		$this->end_controls_tabs();     

        $this->end_controls_section();

    } 

    protected function register_controls() {

        $this->register_content_section_1();
        $this->register_style_section_1();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        if ($this->theme_is_edit_mode()) {
            echo '<div class="post-title">';
            echo '<button class="d-flex align-items-center" href="#"><div class="my-icon-wrapper">';
            \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] );
            echo '</div>';
            echo esc_html($settings['text']);
            echo '</button>';
            echo '</div>';
        } else {
            global $post;

            echo '<div class="post-title">';
            $post_id = get_the_ID();
			echo '<a href="' . esc_url( get_permalink( $post_id) ) . '">';
            echo '<button class="d-flex align-items-center">';
            \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); 
            echo esc_html($settings['text']);
            echo '</button>';
			echo '</a>';
            echo '</div>';
        }
    }
}