<?php

Redux::set_section($opt_name, array(
    'title'      => esc_html__('Invoice', THEME_NAME),
    'id'         => 'redux-Invoice',
    'desc'       => esc_html__('edit option for pwa app', THEME_NAME),
    'subsection' => false,
    'icon'       => 'isax isax-printer4',
    'fields'     => array(
		array(
			'id' => 'Invoice_enable',
			'type' => 'switch',
			'on' => esc_html__( 'enable', THEME_NAME ),
			'off' => esc_html__( 'disable', THEME_NAME ),
			'title' => esc_html__( 'anable Invoice', THEME_NAME ),
			'desc' => '',
			'default' => true,
		),

		array(
			'id' => 'Invoice_template',
			'type' => 'select',
			'title' => esc_html__( 'Page Invoice Template', THEME_NAME ),
			'subtitle' => esc_html__( 'Select template for Invoice page.', THEME_NAME ),
			'data' => 'callback',
			'args' => 'get_all_other_template',
			'desc' => sprintf( esc_html__( 'create your template in %1$s theme other Templates %2$s', THEME_NAME ), '<a target="_blank" href="' . admin_url( "edit.php?post_type=theme-other" ) . '"><b>', '</b></a>' ),
			'default' => '0',
			'select2' => array( 'allowClear' => false ),
		),

		array(
			'id' => 'title-i-1',
			'type' => 'raw',
			'full_width' => true,
			'content' => '<h2>' . esc_html__( 'Buttons', THEME_NAME ) . '</h2>',
		),

		array(
			'id' => 'ar_invoice_email_print_link',
			'type' => 'switch',
			'on' => esc_html__( 'yes', THEME_NAME ),
			'off' => esc_html__( 'no', THEME_NAME ),
			'title' => esc_html__( 'Show print link in customer emails', THEME_NAME ),
			'desc' => '',
			'default' => true,
			'required' => array( 'Invoice_enable', '=', true ),
		),

		array(
			'id' => 'ar_invoice_admin_email_print_link',
			'type' => 'switch',
			'on' => esc_html__( 'yes', THEME_NAME ),
			'off' => esc_html__( 'no', THEME_NAME ),
			'title' => esc_html__( 'Show print link in admin emails', THEME_NAME ),
			'desc' => '',
			'default' => true,
			'required' => array( 'Invoice_enable', '=', true ),
		),

		array(
			'id' => 'ar_invoice_print_button_on_view_order_page',
			'type' => 'switch',
			'on' => esc_html__( 'yes', THEME_NAME ),
			'off' => esc_html__( 'no', THEME_NAME ),
			'title' => esc_html__( 'Show print button on View Order page', THEME_NAME ),
			'desc' => '',
			'default' => true,
			'required' => array( 'Invoice_enable', '=', true ),
		),

		array(
			'id' => 'ar_invoice_print_button_on_my_account_page',
			'type' => 'switch',
			'on' => esc_html__( 'yes', THEME_NAME ),
			'off' => esc_html__( 'no', THEME_NAME ),
			'title' => esc_html__( 'Show print button on My Account page', THEME_NAME ),
			'desc' => '',
			'default' => true,
			'required' => array( 'Invoice_enable', '=', true ),
		),

	),
));
