<?php

Redux::set_section($opt_name, array(
    'title'      => esc_html__('pwa', THEME_NAME),
    'id'         => 'redux-pwa',
    'desc'       => esc_html__('edit option for pwa app', THEME_NAME),
    'subsection' => false,
    'icon'       => 'isax isax-mobile',
    'fields'     => array(
		array(
			'id' => 'pwa_enable',
			'type' => 'switch',
			'on' => esc_html__( 'enable', THEME_NAME ),
			'off' => esc_html__( 'disable', THEME_NAME ),
			'title' => esc_html__( 'anable pwa for website', THEME_NAME ),
			'desc' => '',
			'default' => true,
		),
		array(
            'id'           => 'pwa_theme_color',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('pwa theme color', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '#232332',
            'validate'     => 'color',
			'required' => array( 'pwa_enable', '=', true ),
        ),

        array(
            'id'           => 'pwa_background_color',
            'type'         => 'color',
            'transparent'  => false,
            'title'        => esc_html__('pwa background color', THEME_NAME),
            'subtitle'     => '',
            'desc'         => '',
            'default'      => '#232332',
            'validate'     => 'color',
			'required' => array( 'pwa_enable', '=', true ),
		),

		array(
			'id' => 'pwa_icon_512',
			'type' => 'media',
			'url' => false,
			'title' => esc_html__( '512*512 icon', THEME_NAME ),
			'desc' => esc_html__( 'the icon size should be in 512*512', THEME_NAME ),
			'default' => array(),
			'required' => array( 'pwa_enable', '=', true ),
		),

		array(
			'id' => 'pwa_display',
			'type' => 'select',
			'title' => __( 'pwa display type', THEME_NAME ),
			'options' => array(
				'standalone' => __( 'standalone', THEME_NAME ),
				'fullscreen' => __( 'fullscreen', THEME_NAME ),
				'minimal-ui' => __( 'minimal ui', THEME_NAME ),
				'browser' => __( 'browser', THEME_NAME ),
			),
			'default' => 'standalone',
			'required' => array( 'pwa_enable', '=', true ),
		),

		array(
			'id' => 'pwa_dir',
			'type' => 'select',
			'title' => __( 'pwa direction', THEME_NAME ),
			'options' => array(
				'auto' => __( 'auto', THEME_NAME ),
				'rtl' => __( 'right to left', THEME_NAME ),
				'left' => __( 'left to right', THEME_NAME ),
			),
			'default' => 'auto',
			'required' => array( 'pwa_enable', '=', true ),
		),

    ),
));
