<?php
$all_post_type = array();
$post_types = theme_post_type();

$all_post_type[] = array(
	'id' => 'search-template',
	'type' => 'select',
	'title' => __( 'search template', THEME_NAME ),
	'data' => 'callback',
	'args' => 'get_all_other_template',
	'desc' => sprintf( esc_html__( 'create your template in %1$s theme other Templates %2$s', THEME_NAME ), '<a target="_blank" href="' . admin_url( "edit.php?post_type=theme-other" ) . '"><b>', '</b></a>' ),
	'default' => '0',
	'select2' => array( 'allowClear' => true ),
);

foreach ($post_types as $post_type ) {
	if ( $post_type['name'] ) {
		$all_post_type[] = array(
			'id' => 'subtitle-' . $post_type['name'],
			'type' => 'raw',
			'full_width' => true,
			'content' => '<h4>' . $post_type['title'] . '</h4>',
		);

		$all_post_type[] = array(
			'id' => 'archive-' . $post_type['name'],
			'type' => 'select',
			'title' => $post_type['title'] . __( ' archive', THEME_NAME ),
			'data' => 'callback',
			'args' => 'get_all_other_template',
			'desc' => sprintf( esc_html__( 'create your template in %1$s theme other Templates %2$s', THEME_NAME ), '<a target="_blank" href="' . admin_url( "edit.php?post_type=theme-other" ) . '"><b>', '</b></a>' ),
			'default' => '0',
			'select2' => array( 'allowClear' => false ),
		);

		$all_post_type[] = array(
			'id' => 'single-' . $post_type['name'],
			'type' => 'select',
			'title' => $post_type['title'] . __( ' single', THEME_NAME ),
			'data' => 'callback',
			'args' => 'get_all_other_template',
			'desc' => sprintf( esc_html__( 'create your template in %1$s theme other Templates %2$s', THEME_NAME ), '<a target="_blank" href="' . admin_url( "edit.php?post_type=theme-other" ) . '"><b>', '</b></a>' ),
			'default' => '0',
			'select2' => array( 'allowClear' => false ),
		);

		$all_post_type[] = array(
			'id' => 'display-name-' . $post_type['name'],
			'type' => 'select',
			'title' => $post_type['title'] . __( ' display name', THEME_NAME ),
			'type' => 'text',
			'default' => '',
		);

		$all_post_type[] = array(
			'id' => $post_type['name'] . '-attribute',
			'type' => 'multi_text',
			'title' => __( $post_type['title'], THEME_NAME ) . __( ' attribute', THEME_NAME ),
			'subtitle' => esc_html__( 'add attribute that you want to show in single page.', THEME_NAME ),
			'select2' => array( 'allowClear' => true ),

		);

		$all_post_type[] = array(
			'id' => 'subtitle-custom-post-type',
			'type' => 'raw',
			'full_width' => true,
			'content' => '<h4>' . __( 'custom post type', THEME_NAME ) . '</h4>',
		);
	}
    
}
$all_post_type[] = array(
    'id'       => 'user-post-type',
    'type'     => 'multi_text',
    'title'    => esc_html__('your custom page type', THEME_NAME),
    'subtitle' => esc_html__('just inter name of your custom post type in english we made it!', THEME_NAME),
    'select2'  => array( 'allowClear' => true ),
);

Redux::set_section($opt_name, array(
    'title'            => esc_html__('other pages', THEME_NAME),
    'id'               => 'other-page-sec',
    'desc'             => esc_html__('sellect your auth template here', THEME_NAME),
    'subsection'       => false,
    'icon'             => 'isax isax-note',
    'fields'           => $all_post_type
));


