<?php

$fields = array();

$fields[] = array(
    'id'       => 'page-single-product-template',
    'type'     => 'select',
    'title'    => esc_html__('Page single product Template', THEME_NAME),
    'subtitle' => esc_html__('Select template for page single product page.', THEME_NAME),
    'data'     => 'callback',
    'args'     => 'get_all_other_template',
    'desc'     => sprintf(esc_html__('create your template in %1$s theme other Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-other") . '"><b>', '</b></a>'),
    'default'  => '0',
    'select2'  => array( 'allowClear' => false ),
);

$fields[] = array(
    'id'       => 'page-shop-product-template',
    'type'     => 'select',
    'title'    => esc_html__('Page shop product Template', THEME_NAME),
    'subtitle' => esc_html__('Select template for page single product page.', THEME_NAME),
    'data'     => 'callback',
    'args'     => 'get_all_other_template',
    'desc'     => sprintf(esc_html__('create your template in %1$s theme other Templates %2$s', THEME_NAME), '<a target="_blank" href="' . admin_url("edit.php?post_type=theme-other") . '"><b>', '</b></a>'),
    'default'  => '0',
    'select2'  => array( 'allowClear' => false ),
);

$fields[] = array(
	'id' => 'page-single-product-attribute',
	'type' => 'multi_text',
	'title' => esc_html__( 'Page Single Product attribute', THEME_NAME ),
	'subtitle' => esc_html__( 'add product attribute that you want to show in product page.', THEME_NAME ),
	'select2' => array( 'allowClear' => true ),
);


$product_attribute_items = option_value( 'page-single-product-attribute' );
if($product_attribute_items){
    foreach ( $product_attribute_items as $product_attribute_item ) {
        $fields[] = array(
            'id'       => 'product-attribute-kind-' . esc_html($product_attribute_item),
            'type'     => 'select',
            'title'    => esc_html__('kind of ', THEME_NAME) . esc_html($product_attribute_item),
            'default' => 'text',
            'options' => array(
                'text' => __('text', THEME_NAME) ,
                'image' => __( 'image', THEME_NAME ),
                'video' => __( 'video', THEME_NAME ),
                'audio' => __( 'audio', THEME_NAME ),
                'file' => __( 'file', THEME_NAME ),
            ),
        );
    }
}

Redux::set_section($opt_name, array(
    'title'            => esc_html__('woocommerce pages', THEME_NAME),
    'id'               => 'woocommerce-sec',
    'desc'             => esc_html__('sellect your auth template here', THEME_NAME),
    'subsection'       => false,
    'icon'             => 'isax isax-shop',
    'fields'           => $fields
));

$all_field_billing = array();
$billing_fields = woocommerce_billing_fields();

foreach ($billing_fields as $field_key => $field_value) {
    $all_field_billing[] = array(
        'id'          => 'subtitle-' . $field_value,
        'type'        => 'raw',
        'full_width'  => true,
        'content'     => '<h4>' . $field_value . '</h4>',
    );
    $all_field_billing[] = array(
        'id' => 'billing_' . $field_key,
        'type' => 'switch',
        'title' => $field_value,
        'default' => true,
    );
    $all_field_billing[] = array(
        'id' => $field_key.'_label',
        'type' => 'text',
        'title' => $field_value . esc_html__(' Label', THEME_NAME),
    );
    $all_field_billing[] = array(
        'id' => $field_key.'_required',
        'type' => 'switch',
        'title' => $field_value . esc_html__(' Required', THEME_NAME),
        'default' => true,
    );
    $all_field_billing[] = array(
        'id' => $field_key.'_priority',
        'type' => 'spinner',
        'title' => $field_value . esc_html__(' priority', THEME_NAME),
        'step'        => '1',
        'min'         => '0',
        'max'         => '100',
    );
}

Redux::setSection($opt_name, array(
    'title' => esc_html__('Billing Fields', THEME_NAME),
    'id' => 'woocommerce_billing_fields',
    'subsection' => true,
    'fields' =>$all_field_billing,
));

$all_field_shipping = array();
$shipping_fields = woocommerce_shipping_fields();

foreach ($shipping_fields as $field_key => $field_value) {
    $all_field_shipping[] = array(
        'id'          => 'subtitle-' . $field_value,
        'type'        => 'raw',
        'full_width'  => true,
        'content'     => '<h4>' . $field_value . '</h4>',
    );
    $all_field_shipping[] = array(
        'id' => 'shipping_' . $field_key,
        'type' => 'switch',
        'title' => $field_value,
        'default' => true,
    );
    $all_field_shipping[] = array(
        'id' => $field_key.'_label',
        'type' => 'text',
        'title' => $field_value . esc_html__(' Label', THEME_NAME),
    );
    $all_field_shipping[] = array(
        'id' => $field_key.'_required',
        'type' => 'switch',
        'title' => $field_value . esc_html__(' Required', THEME_NAME),
        'default' => true,
    );
    $all_field_shipping[] = array(
        'id' => $field_key.'_priority',
        'type' => 'spinner',
        'title' => $field_value . esc_html__(' priority', THEME_NAME),
        'step'        => '1',
        'min'         => '0',
        'max'         => '100',
    );
}

Redux::setSection($opt_name, array(
    'title' => esc_html__('shipping Fields', THEME_NAME),
    'id' => 'woocommerce_shipping_fields',
    'subsection' => true,
    'fields' =>$all_field_shipping,
));

$all_field_profile = array();
$profile_fields = all_woocommerce_profile_fields();

foreach ( $profile_fields as $field_key => $field_value ) {
	if ( !is_array( $field_value ) ) {
		$all_field_profile[] = array(
			'id' => $field_key . '_label',
			'type' => 'text',
			'title' => $field_value . esc_html__( ' Label', THEME_NAME ),
		);
	}
    else{
		$field_value = $field_value['name'];
        $all_field_profile[] = array(
            'id' => 'subtitle-' . $field_value,
            'type' => 'raw',
            'full_width' => true,
            'content' => '<h4>' . $field_value . '</h4>',
        );

		$all_field_profile[] = array(
			'id' => $field_value . '_label',
			'type' => 'text',
			'title' => $field_value . esc_html__( ' Label', THEME_NAME ),
		);

		$all_field_profile[] = array(
			'id' => $field_value . '_slug',
			'type' => 'text',
			'title' => $field_value . esc_html__( ' slug', THEME_NAME ),
		);

        $all_field_profile[] = array(
            'id' => $field_value.'_profile_template',
            'type' => 'select',
            'title' => esc_html__( 'Page content', THEME_NAME ),
            'subtitle' => esc_html__( 'Select template for page content.', THEME_NAME ),
            'data' => 'callback',
            'args' => 'get_all_other_template',
            'desc' => sprintf( esc_html__( 'create your template in %1$s theme other Templates %2$s', THEME_NAME ), '<a target="_blank" href="' . admin_url( "edit.php?post_type=theme-other" ) . '"><b>', '</b></a>' ),
            'default' => '0',
            'select2' => array( 'allowClear' => false ),
        );
    }
}
$all_field_profile[] = array(
	'id' => 'subtitle-custom-profile-field',
	'type' => 'raw',
	'full_width' => true,
	'content' => '<h4>' . __( 'custom profile field', THEME_NAME ) . '</h4>',
);

$all_field_profile[] = array(
	'id' => 'woocommerce_profile_fields-custom-feild',
	'type' => 'multi_text',
	'title' => esc_html__( 'your custom tab', THEME_NAME ),
	'subtitle' => esc_html__( 'just inter name of your custom feild type in english we made it!', THEME_NAME ),
	'select2' => array( 'allowClear' => true ),
);

Redux::setSection( $opt_name, array(
	'title' => esc_html__( 'profile Fields', THEME_NAME ),
	'id' => 'woocommerce_profile_fields',
	'subsection' => true,
	'fields' => $all_field_profile,
) );