<?php

Redux::set_section( $opt_name, array(
    'title'            =>  esc_html__('General', THEME_NAME),
    'id'               => 'general_section',
    'desc'             =>  esc_html__('General settings for site', THEME_NAME),
    'icon'             => 'isax isax-global-edit',
    'fields'           => array(  
        array(
            'id'        => 'site-width',
            'type'      => 'slider',
            'title'     => esc_html__('Site Width', THEME_NAME),
            'subtitle'  => esc_html__('Choose the site width.', THEME_NAME),
            'default'   => 1400,
            'min'       => 1000,
            'step'      => 1,
            'max'       => 1600,
        ),		

        array(
            'id'       => 'smooth-scroll',
            'type'     => 'switch',
            'title'    => esc_html__('Smooth Scroll', THEME_NAME),
            'subtitle' => esc_html__('Smooth scroll in website.', THEME_NAME),
            'desc'     => '',
            'default'  => true,
        ),

        array(
            'id'       => 'site_icon',
            'type'     => 'media',
            'url'      => false,
            'title'    => esc_html__('Site Icon', THEME_NAME),
            'desc'     => esc_html__('Upload or select a site icon.', THEME_NAME),
            'default'  => array(),
        ),

        array(
            'id'       => 'theme-favicon',
            'type'     => 'media',
            'url'      => false,
            'title'    => esc_html__('Favicon', THEME_NAME),
            'desc'     => esc_html__('Upload or select a favicon.', THEME_NAME),
            'default'  => array(),
        ),

        array(
            'id'       => 'theme-retina',
            'type'     => 'media',
            'url'      => false,
            'title'    => esc_html__('Retina Icon', THEME_NAME),
            'desc'     => esc_html__('Upload or select a retina icon.', THEME_NAME),
            'default'  => array(),
        ),

        array(
            'id'       => 'theme-preloader',
            'type'     => 'switch',
            'title'    => esc_html__('Preloader', THEME_NAME),
            'subtitle' => esc_html__('Show site preloader transition before site loaded.', THEME_NAME),
            'desc'     => '',
            'default'  => true,
        ),
        
        array(
            'id'               => 'theme-preloader-kind',
            'type'             => 'select',
            'title'            => __( 'loading page kind' , THEME_NAME ),
            'options'          => array(
                'pre build'    => __('pre build' , THEME_NAME ),
                'custom image' => __('custom image' , THEME_NAME ),
            ),
            'default'          => 'pre build',
            'required'         => array( 'theme-preloader', '=', true )
        ),

        array(
            'id'               => 'theme-preloader-pre-build',
            'type'             => 'select',
            'title'            => __( 'pre buid style' , THEME_NAME ),
            'options'          => array(
                '1'            => __('style 1' , THEME_NAME ),
                '2'            => __('style 2' , THEME_NAME ),
                '3'            => __('style 3' , THEME_NAME ),
                '4'            => __('style 4' , THEME_NAME ),
                '5'            => __('style 5' , THEME_NAME ),
                '6'            => __('style 6' , THEME_NAME ),
                '7'            => __('style 7' , THEME_NAME ),
                '8'            => __('style 8' , THEME_NAME ),
                '9'            => __('style 9' , THEME_NAME ),
                '10'            => __('style 10' , THEME_NAME ),
                '11'            => __('style 11' , THEME_NAME ),
                '12'            => __('style 12' , THEME_NAME ),
                '13'            => __('style 13' , THEME_NAME ),
                '14'            => __('style 14' , THEME_NAME ),
                '15'            => __('style 15' , THEME_NAME ),
                '16'            => __('style 16' , THEME_NAME ),
                '17'            => __('style 17' , THEME_NAME ),
                '18'            => __('style 18' , THEME_NAME ),
                '19'            => __('style 19' , THEME_NAME ),
                '20'            => __('style 20' , THEME_NAME ),
                '21'            => __('style 21' , THEME_NAME ),
                '22'            => __('style 22' , THEME_NAME ),
                '23'            => __('style 23' , THEME_NAME ),
                '24'            => __('style 24' , THEME_NAME ),
                '25'            => __('style 25' , THEME_NAME ),
                '26'            => __('style 26' , THEME_NAME ),
                '27'            => __('style 27' , THEME_NAME ),
                '28'            => __('style 28' , THEME_NAME ),
                '29'            => __('style 29' , THEME_NAME ),
                '30'            => __('style 30' , THEME_NAME ),
                '31'            => __('style 31' , THEME_NAME ),
                '32'            => __('style 32' , THEME_NAME ),
                '33'            => __('style 33' , THEME_NAME ),
                '34'            => __('style 34' , THEME_NAME ),
                '35'            => __('style 35' , THEME_NAME ),
                '36'            => __('style 36' , THEME_NAME ),
                '37'            => __('style 37' , THEME_NAME ),
                '38'            => __('style 38' , THEME_NAME ),
                '39'            => __('style 39' , THEME_NAME ),
                '40'            => __('style 40' , THEME_NAME ),
                '41'            => __('style 41' , THEME_NAME ),
                '42'            => __('style 42' , THEME_NAME ),
                '43'            => __('style 43' , THEME_NAME ),
                '44'            => __('style 44' , THEME_NAME ),
                '45'            => __('style 45' , THEME_NAME ),
                '46'            => __('style 46' , THEME_NAME ),
                '47'            => __('style 47' , THEME_NAME ),
                '48'            => __('style 48' , THEME_NAME ),
                '49'            => __('style 49' , THEME_NAME ),
                '50'            => __('style 50' , THEME_NAME ),
                '51'            => __('style 51' , THEME_NAME ),
                '52'            => __('style 52' , THEME_NAME ),
                '53'            => __('style 53' , THEME_NAME ),
                '54'            => __('style 54' , THEME_NAME ),
                '55'            => __('style 55' , THEME_NAME ),
                '56'            => __('style 56' , THEME_NAME ),
                '57'            => __('style 57' , THEME_NAME ),
                '58'            => __('style 58' , THEME_NAME ),
                '59'            => __('style 59' , THEME_NAME ),
                '60'            => __('style 60' , THEME_NAME ),
                '61'            => __('style 61' , THEME_NAME ),
                '62'            => __('style 62' , THEME_NAME ),
                '63'            => __('style 63' , THEME_NAME ),
                '64'            => __('style 64' , THEME_NAME ),
                '65'            => __('style 65' , THEME_NAME ),
                '66'            => __('style 66' , THEME_NAME ),
                '67'            => __('style 67' , THEME_NAME ),
                '68'            => __('style 68' , THEME_NAME ),
                '69'            => __('style 69' , THEME_NAME ),
                '70'            => __('style 70' , THEME_NAME ),
            ),
            'default'          => '1',
            'required'         => array(
                'theme-preloader-kind', '=', 'pre build'
            )
        ),

        array(
            'id'       => 'theme-preloader-image',
            'type'     => 'media',
            'title'    => __( 'upload image' , THEME_NAME ),
            'desc'     => __( 'upload image png,jpg' , THEME_NAME ),
            'url'      => false,
            'required' => array(
                'theme-preloader-kind', '=', 'custom image',
            )
        ),

        array(
            'id'       => 'full-size-img',
            'type'     => 'switch',
            'title'    => esc_html__('Full Size Gif Images', THEME_NAME),
            'subtitle' => esc_html__('Use full image size for Gif. It is useful to show gif animation in thumbnail.', THEME_NAME),
            'desc'     => '',
            'default'  => true,
        ),
    )
) );