jQuery(document).ready(function($) {
    $('.mega-menu-advance-switcher').on('click', function() {
        var $switcher = $(this);
        var $input = $switcher.find('input[type="hidden"]');
        var $advancePanel = $switcher.closest('.menu-option').find('.advance-panel');

        if ($input.val() == '0') {
            // Turn on
            $switcher.addClass('mega-menu-advance-active');
            $switcher.find('.mega-menu-advance-on').css('opacity', 1);
            $switcher.find('.mega-menu-advance-off').css('opacity', 0);
            $switcher.find('.mega-menu-advance-ball').css('left', 'calc(100% - 28px)');
            $input.val('1');
            $advancePanel.slideDown();
        } else {
            // Turn off
            $switcher.removeClass('mega-menu-advance-active');
            $switcher.find('.mega-menu-advance-on').css('opacity', 0);
            $switcher.find('.mega-menu-advance-off').css('opacity', 1);
            $switcher.find('.mega-menu-advance-ball').css('left', '4px');
            $input.val('0');
            $advancePanel.slideUp();
        }
    });

    // Initialize based on the hidden input value
    $('.mega-menu-advance-switcher').each(function() {
        var $switcher = $(this);
        var $input = $switcher.find('input[type="hidden"]');
        var $advancePanel = $switcher.closest('.menu-option').find('.advance-panel');

        if ($input.val() == '1') {
            // If the initial value is 1 (on)
            $switcher.addClass('mega-menu-advance-active');
            $switcher.find('.mega-menu-advance-on').css('opacity', 1);
            $switcher.find('.mega-menu-advance-off').css('opacity', 0);
            $switcher.find('.mega-menu-advance-ball').css('left', 'calc(100% - 28px)');
            $advancePanel.show();
        } else {
            // If the initial value is 0 (off)
            $advancePanel.hide();
        }
    } );
    
    // Toggle the icon list dropdown
    $( '.custom-icon-dropdown .selected-icon-chooser' ).on( 'click', function ()
    {
        var $icon_list = $(this).closest('.icon-chooser-btn');
        $icon_list.siblings('.icon-list').slideToggle();
        $( this ).siblings( '.icon-search' ).slideToggle();
    });

    $( '.icon-list' ).slideUp();
    
    // Update the selected icon when an option is clicked
    $('.custom-icon-dropdown .icon-list li').on('click', function() {
        var selectedIcon = $(this).data('value');
        var iconHtml = $(this).html();

        // Update the displayed selected icon
        var $dropdown = $(this).closest('.custom-icon-dropdown');
        $dropdown.find('.selected-icon').html(iconHtml + '<i class = "isax isax-gallery-remove5 remove-icon"></i> ');
        
        // Hide the chooser button and show the selected icon div
        $dropdown.find('.selected-icon-chooser').hide();
        $dropdown.find( '.selected-icon' ).show();
        $dropdown.find('.icon-search').hide();
        
        // Update the hidden input with the selected icon value
        $dropdown.find('input[type="hidden"]').val(selectedIcon);

        // Close the dropdown
        $(this).parent('.icon-list').slideUp();
    });
    
    $( '.custom-icon-dropdown .icon-search' ).on( 'input', function ()
    {
        var $dropdown = $(this).closest('.custom-icon-dropdown');
        var searchValue = $(this).val().toLowerCase();

        $dropdown.find('.icon-list').find('li').each(function() {
            var iconValue = $(this).data('value').toLowerCase();
            if (iconValue.includes(searchValue)) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });

    // Handle icon removal
    $(document).on('click', '.custom-icon-dropdown .remove-icon', function() {
        var $dropdown = $(this).closest('.custom-icon-dropdown');

        // Clear the hidden input value
        $dropdown.find('input[type="hidden"]').val('0');

        // Show the chooser button again and hide the selected icon
        $dropdown.find('.icon-search').hide();
        $dropdown.find('.selected-icon-chooser').show();
        $dropdown.find( '.selected-icon' ).hide();
    });

    // Initial setup: show/hide chooser or selected icon
    $('.custom-icon-dropdown').each(function() {
        var $dropdown = $(this);
        var selectedIcon = $dropdown.find('input[type="hidden"]').val();
        if (selectedIcon === '0' || selectedIcon === '') {
            $dropdown.find('.selected-icon').hide();
            $dropdown.find('.selected-icon-chooser').show();
        } else {
            $dropdown.find('.selected-icon').html('<i class="choose-icon isax isax-' + selectedIcon + '"></i> <i class = "isax isax-gallery-remove5 remove-icon"></i>').show();
            $dropdown.find('.selected-icon-chooser').hide();
        }
    } );
    
    // Media Uploader
    $('.media-input .media-select-button').on('click', function(e) {
        e.preventDefault();
        var $button = $(this);
        var $mediaInput = $button.siblings('input.media-url');
        var $mediaPreview = $button.siblings('.media-preview');

        // Create a new media frame
        var mediaFrame = wp.media({
            title: $button.data('title') || 'Select Image',
            button: { text: 'Use Image' },
            multiple: false,
            library: { type: 'image' } // Filter for images
        });

        // When an image is selected, run a callback
        mediaFrame.on('select', function() {
            var attachment = mediaFrame.state().get('selection').first().toJSON();
            $mediaInput.val(attachment.url);
            $mediaPreview.html('<img src="' + attachment.url + '" alt="" style="max-width: 100%; height: auto;">' +
                '<i class = "isax isax-gallery-remove5 media-remove-button remove-icon"></i>');
        });

        // Open the media frame
        mediaFrame.open();
    });

    // Handle icon removal
    $(document).on('click', '.media-remove-button', function() {
        var $media_input = $(this).closest('.media-input');
        var $mediaPreview = $( this ).closest('.media-preview');
        var $mediaInput = $media_input.find('input.media-url');

        // Clear the hidden input value
        $mediaInput.val('0');

        // Remove the image and hide the remove button
        $mediaPreview.html('');
    });
});
